/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.model.Game;
import jgamebase.gui.Gui;
import jgamebase.gui.ListListModel;
import jgamebase.gui.PathsDialog;
import jgamebase.model.Emulators;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.DiskInfo;
import jgamebase.plugins.Extractor;
import jgamebase.tools.FileTools;
import jgamebase.tools.ListerTools;
import jgamebase.tools.TempDir;

public class GameChooserDialog
extends JDialog {
    private static final long serialVersionUID = -5736953616975309056L;
    private String path;
    private boolean pathAdjusting = false;
    private Const.CloseAction closeAction = Const.CloseAction.CANCEL;
    private final Object[] fileFilters = new Object[]{new FileFilter("All files", "*"), new FileFilter("Only compressed files", Plugins.getSupportedExtractorExtension()), new FileFilter("Only image files", Plugins.getSupportedDiskInfoExtension()), new FileFilter("Only game and image files", Emulators.getSupportedGameExtensions().toString())};
    private static final int STATUS_NOTHING = 0;
    private static final int STATUS_PACKED = 1;
    private static final int STATUS_IMAGE = 2;
    private static final int STATUS_GAME = 3;
    private int status = 0;
    private JComboBox fileFilterComboBox;
    private JList fileSelectionList;
    private JLabel itemLabelBottom;
    private JLabel itemLabelTop;
    private JList itemSelectionList;
    private JPanel itemSelectionPanel;
    private JList packageContentsSelectionList;
    private JPanel packageContentsSelectionPanel;
    private JComboBox pathSelectionComboBox;
    private JList pathSelectionList;
    private JButton testButton;

    public GameChooserDialog() {
        this.init();
        this.setVisible(true);
    }

    public GameChooserDialog(Game game) {
        int i;
        this.init();
        this.path = "";
        String filename = "";
        if (Paths.getGamePath().exists(new File(game.getFilename()))) {
            String filename1 = game.getFilename();
            this.path = Paths.getGamePath().findAndWarn(new File(filename1)) != null ? Paths.getGamePath().findAndWarn(new File(filename1)).getPath() : "";
            filename = Paths.removePath(game.getFilename());
            this.path = this.path.substring(0, this.path.length() - filename.length());
        }
        Object[] basePaths = ListerTools.fileListToStringList(Paths.getGamePath().getWithDefault()).toArray();
        if (Paths.getGamePath().whichBasePath(new File(game.getFilename())) != null) {
            String basePath = Paths.getGamePath().whichBasePath(new File(game.getFilename())).getPath();
            i = 0;
            while (i < basePaths.length) {
                if (basePath.equals(Paths.pathEndingWithSeparator((String)basePaths[i]))) {
                    this.pathAdjusting = true;
                    this.pathSelectionComboBox.setSelectedIndex(i);
                    this.pathAdjusting = false;
                }
                ++i;
            }
        }
        this.fillPathSelectionList();
        this.fillFileSelectionList();
        List files = ((ListListModel)this.fileSelectionList.getModel()).get();
        i = 0;
        for (String filenameFromList : files) {
            if (filename.equals(filenameFromList)) {
                this.fileSelectionList.setSelectedIndex(i);
            }
            ++i;
        }
        if (this.status == 2) {
            this.itemSelectionList.setSelectedIndex(game.getFilenameIndex());
        } else if (this.status == 1) {
            List list = ((ListListModel)this.packageContentsSelectionList.getModel()).get();
            int j = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String image = Paths.removePath((String)iter.next());
                if (game.getFileToRun().equals(image)) {
                    this.packageContentsSelectionList.setSelectedIndex(j);
                }
                ++j;
            }
            this.itemSelectionList.setSelectedIndex(game.getFilenameIndex());
        }
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void init() {
        this.initComponents();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getGamePath().getWithDefault()).toArray()));
        this.pathSelectionList.setCellRenderer(new PathSelectionRenderer());
        this.pathSelectionList.setModel(new ListListModel());
        this.path = "";
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            this.path = (String)this.pathSelectionComboBox.getSelectedItem();
        }
        this.fillPathSelectionList();
        this.fileFilterComboBox.setModel(new DefaultComboBoxModel<Object>(this.fileFilters));
        this.fileSelectionList.setCellRenderer(new FileSelectionRenderer());
        this.fileSelectionList.setModel(new ListListModel());
        this.fillFileSelectionList();
        this.setPackageEnabled(false);
        this.setItemEnabled(false);
        this.setTestEnabled(false);
        this.packageContentsSelectionList.setCellRenderer(new FileSelectionRenderer());
        this.packageContentsSelectionList.setModel(new ListListModel());
        this.itemSelectionList.setModel(new ListListModel());
    }

    private String getBasePath() {
        if (this.pathSelectionComboBox.getSelectedItem() != null && this.pathSelectionComboBox.getSelectedItem() instanceof String) {
            return Paths.pathEndingWithSeparator((String)this.pathSelectionComboBox.getSelectedItem());
        }
        return "";
    }

    private String getPathWithoutBasePath() {
        if (this.getBasePath().isEmpty() || this.path.isEmpty() || this.getBasePath().length() >= this.path.length()) {
            return "";
        }
        return this.path.substring(this.getBasePath().length());
    }

    /*
     * WARNING - void declaration
     */
    private void fillPathSelectionList() {
        void var5_8;
        ArrayList<PathSelection> paths = new ArrayList<PathSelection>();
        int indentation = 0;
        this.pathAdjusting = true;
        paths.add(new PathSelection(0, this.getBasePath()));
        ++indentation;
        String dirPath = "";
        StringTokenizer st = new StringTokenizer(this.getPathWithoutBasePath(), File.separator);
        while (st.hasMoreTokens()) {
            dirPath = String.valueOf(dirPath) + Paths.pathEndingWithSeparator(st.nextToken());
            if (!new File(String.valueOf(this.getBasePath()) + dirPath).isDirectory()) continue;
            paths.add(new PathSelection(++indentation, String.valueOf(this.getBasePath()) + Paths.pathStartingWithoutSeparator(dirPath)));
        }
        ++indentation;
        List<Object> dirs = new ArrayList();
        try {
            dirs = ListerTools.list_Dirs_Files_Paths(this.path, true, false, true);
        }
        catch (Exception exception) {}
        Collections.sort(dirs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        for (String string : dirs) {
            paths.add(new PathSelection(indentation, string));
        }
        ((ListListModel)this.pathSelectionList.getModel()).set(paths);
        boolean bl = false;
        while (var5_8 < paths.size()) {
            if (this.path.startsWith(((PathSelection)this.pathSelectionList.getModel().getElementAt((int)var5_8)).getPath())) {
                this.pathSelectionList.setSelectedIndex((int)var5_8);
            }
            ++var5_8;
        }
        this.pathSelectionList.setSelectedValue(this.pathSelectionList.getSelectedValue(), true);
        this.pathAdjusting = false;
    }

    private void fillFileSelectionList() {
        List<Object> files = new ArrayList();
        try {
            files = new FileExtensions(((FileFilter)this.fileFilterComboBox.getSelectedItem()).getExtensions()).getMatching(ListerTools.list_Dirs_Files_Paths(this.path, false, true, false));
        }
        catch (Exception exception) {}
        Collections.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        ((ListListModel)this.fileSelectionList.getModel()).set(files);
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        JPanel mainFileSelectionPanel = new JPanel();
        JPanel pathSelectionPanel = new JPanel();
        this.pathSelectionComboBox = new JComboBox();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.pathSelectionList = new JList();
        JButton jButton2 = new JButton();
        JPanel fileSelectionPanel = new JPanel();
        this.fileFilterComboBox = new JComboBox();
        JButton fileSelectionButton = new JButton();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.fileSelectionList = new JList();
        JLabel jLabel1 = new JLabel();
        this.packageContentsSelectionPanel = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.packageContentsSelectionList = new JList();
        this.itemSelectionPanel = new JPanel();
        this.itemLabelTop = new JLabel();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.itemSelectionList = new JList();
        this.itemLabelBottom = new JLabel();
        JPanel mainFileActionPanel = new JPanel();
        this.testButton = new JButton();
        JPanel OkCancelPanel = new JPanel();
        JPanel jPanel9 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setTitle("Game Selector");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GameChooserDialog.this.exitFormWindowClosing(evt);
            }
        });
        mainPanel.setLayout(new BorderLayout());
        mainFileSelectionPanel.setLayout(new GridLayout(2, 2, 5, 5));
        pathSelectionPanel.setBorder(BorderFactory.createTitledBorder("1. Select Path"));
        pathSelectionPanel.setLayout(new GridBagLayout());
        this.pathSelectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.pathChoosen_ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        pathSelectionPanel.add((Component)this.pathSelectionComboBox, gridBagConstraints);
        this.pathSelectionList.setSelectionMode(0);
        this.pathSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GameChooserDialog.this.pathSelected_ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.pathSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        pathSelectionPanel.add((Component)jScrollPane1, gridBagConstraints);
        jButton2.setMnemonic('E');
        jButton2.setText("Edit");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.editPaths_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        pathSelectionPanel.add((Component)jButton2, gridBagConstraints);
        mainFileSelectionPanel.add(pathSelectionPanel);
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder("2. Select File"));
        fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileFilterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.fileFilterSelected_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 2);
        fileSelectionPanel.add((Component)this.fileFilterComboBox, gridBagConstraints);
        fileSelectionButton.setMnemonic('R');
        fileSelectionButton.setText("Refresh");
        fileSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.refreshFiles_ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 5);
        fileSelectionPanel.add((Component)fileSelectionButton, gridBagConstraints);
        this.fileSelectionList.setSelectionMode(0);
        this.fileSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GameChooserDialog.this.fileSelected_ValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(this.fileSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        fileSelectionPanel.add((Component)jScrollPane2, gridBagConstraints);
        jLabel1.setText("Filter:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 2);
        fileSelectionPanel.add((Component)jLabel1, gridBagConstraints);
        mainFileSelectionPanel.add(fileSelectionPanel);
        this.packageContentsSelectionPanel.setBorder(BorderFactory.createTitledBorder("3. Select Contents"));
        this.packageContentsSelectionPanel.setLayout(new GridBagLayout());
        this.packageContentsSelectionList.setSelectionMode(0);
        this.packageContentsSelectionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GameChooserDialog.this.packageContentsSelected_ValueChanged(evt);
            }
        });
        jScrollPane3.setViewportView(this.packageContentsSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.packageContentsSelectionPanel.add((Component)jScrollPane3, gridBagConstraints);
        mainFileSelectionPanel.add(this.packageContentsSelectionPanel);
        this.itemSelectionPanel.setBorder(BorderFactory.createTitledBorder("4. Select Game"));
        this.itemSelectionPanel.setLayout(new GridBagLayout());
        this.itemLabelTop.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        this.itemSelectionPanel.add((Component)this.itemLabelTop, gridBagConstraints);
        this.itemSelectionList.setFont(new Font("Monospaced", 1, Gui.scaleByFontSize(12)));
        this.itemSelectionList.setSelectionMode(0);
        jScrollPane4.setViewportView(this.itemSelectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 3, 5);
        this.itemSelectionPanel.add((Component)jScrollPane4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.itemSelectionPanel.add((Component)this.itemLabelBottom, gridBagConstraints);
        mainFileSelectionPanel.add(this.itemSelectionPanel);
        mainPanel.add((Component)mainFileSelectionPanel, "Center");
        this.testButton.setMnemonic('T');
        this.testButton.setText("Test Game");
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.testGame_ActionPerformed(evt);
            }
        });
        mainFileActionPanel.add(this.testButton);
        mainPanel.add((Component)mainFileActionPanel, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        OkCancelPanel.setLayout(new BorderLayout());
        jPanel9.setLayout(new FlowLayout(2));
        okButton.setMnemonic('O');
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.okActionPerformed(evt);
            }
        });
        jPanel9.add(okButton);
        cancelButton.setMnemonic('C');
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameChooserDialog.this.cancelActionPerformed(evt);
            }
        });
        jPanel9.add(cancelButton);
        OkCancelPanel.add((Component)jPanel9, "South");
        this.getContentPane().add((Component)OkCancelPanel, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void fileFilterSelected_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionList();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.OK;
        this.dispose();
    }

    private void testGame_ActionPerformed(ActionEvent evt) {
        Game game = new Game();
        Const.log.info((Object)"");
        Const.log.info((Object)("Filename:      " + this.getGameFilename()));
        Const.log.info((Object)("FileToRun:     " + this.getGameFileToRun()));
        Const.log.info((Object)("FilenameIndex: " + this.getGameFilenameIndex()));
        game.setFilename(this.getGameFilename());
        game.setFileToRun(this.getGameFileToRun());
        game.setFilenameIndex(this.getGameFilenameIndex());
        try {
            game.play();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Db.delete(game);
    }

    protected String getGameName() {
        if (this.itemSelectionList.getSelectedValue() != null && this.itemSelectionList.getSelectedValue() instanceof String) {
            return (String)this.itemSelectionList.getSelectedValue();
        }
        return "";
    }

    protected String getGameFilename() {
        if (this.fileSelectionList.getSelectedValue() != null && this.fileSelectionList.getSelectedValue() instanceof String) {
            return Paths.pathStartingWithoutSeparator(String.valueOf(Paths.pathEndingWithSeparator(this.getPathWithoutBasePath())) + this.fileSelectionList.getSelectedValue());
        }
        return "";
    }

    protected String getGameFileToRun() {
        if (this.status == 1 && this.packageContentsSelectionList.getSelectedValue() != null && this.packageContentsSelectionList.getSelectedValue() instanceof String) {
            return Paths.removePath((String)this.packageContentsSelectionList.getSelectedValue());
        }
        return "";
    }

    protected int getGameFilenameIndex() {
        if (this.status == 1 ? this.packageContentsSelectionList.getSelectedValue() != null && this.packageContentsSelectionList.getSelectedValue() instanceof String && Plugins.existsDiskInfoForExtension(FileTools.getExtension((String)this.packageContentsSelectionList.getSelectedValue())) : this.status == 2) {
            return this.itemSelectionList.getSelectedIndex();
        }
        return 0;
    }

    private void pathSelected_ValueChanged(ListSelectionEvent evt) {
        if (this.pathAdjusting) {
            return;
        }
        if (this.pathSelectionList.getSelectedValue() != null && this.pathSelectionList.getSelectedValue() instanceof PathSelection) {
            this.path = ((PathSelection)this.pathSelectionList.getSelectedValue()).getPath();
        }
        this.fillPathSelectionList();
        this.fillFileSelectionList();
    }

    private void packageContentsSelected_ValueChanged(ListSelectionEvent evt) {
        this.fillItemList();
    }

    private void refreshFiles_ActionPerformed(ActionEvent evt) {
        this.fillFileSelectionList();
    }

    private void exitFormWindowClosing(WindowEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeAction = Const.CloseAction.CANCEL;
        this.dispose();
    }

    private void editPaths_ActionPerformed(ActionEvent evt) {
        new PathsDialog();
        this.pathSelectionComboBox.setModel(new DefaultComboBoxModel<Object>(ListerTools.fileListToStringList(Paths.getGamePath().getWithDefault()).toArray()));
        this.fillPathSelectionList();
        this.fillFileSelectionList();
    }

    private void pathChoosen_ActionPerformed(ActionEvent evt) {
        if (this.pathAdjusting) {
            return;
        }
        this.path = this.getBasePath();
        this.fillPathSelectionList();
        this.fillFileSelectionList();
    }

    private void fileSelected_ValueChanged(ListSelectionEvent evt) {
        if (this.fileSelectionList.getSelectedValue() != null && this.fileSelectionList.getSelectedValue() instanceof String) {
            String filename = (String)this.fileSelectionList.getSelectedValue();
            String extension = FileTools.getExtension(filename);
            if (Plugins.existsExtractorForExtension(extension)) {
                this.status = 1;
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_PACKED"));
                this.setPackageEnabled(true);
                this.setItemEnabled(true);
                this.setTestEnabled(true);
                this.fillPackageList();
            } else if (Plugins.existsDiskInfoForExtension(extension)) {
                this.status = 2;
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_IMAGE"));
                this.setPackageEnabled(false);
                this.setItemEnabled(true);
                this.setTestEnabled(true);
                this.fillItemList();
            } else if (Emulators.getSupportedGameExtensions().contains(extension)) {
                this.status = 3;
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_GAME"));
                this.setPackageEnabled(false);
                this.setItemEnabled(false);
                this.setTestEnabled(true);
            } else {
                this.status = 0;
                Const.log.info((Object)(String.valueOf(filename) + ": STATUS_NOTHING"));
                this.setPackageEnabled(false);
                this.setItemEnabled(false);
                this.setTestEnabled(false);
            }
        }
    }

    private void fillPackageList() {
        ArrayList namesOfSsupportedFiles = new ArrayList();
        String filename = String.valueOf(Paths.pathEndingWithSeparator(this.path)) + this.fileSelectionList.getSelectedValue();
        List<Object> filenames = new ArrayList();
        try {
            Extractor extractor = Plugins.getExtractorForExtension(FileTools.getExtension(filename));
            TempDir.cleanPath();
            TempDir.getPath();
            filenames = extractor.extractToDir(filename, TempDir.getPath().getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        namesOfSsupportedFiles.addAll(filenames.stream().filter(filename2 -> Emulators.getSupportedGameExtensions().contains(FileTools.getExtension(filename2))).collect(Collectors.toList()));
        Collections.sort(namesOfSsupportedFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                return FileTools.removeExtension(Paths.removePath(((String)o1).toLowerCase())).compareTo(FileTools.removeExtension(Paths.removePath(((String)o2).toLowerCase())));
            }
        });
        ((ListListModel)this.packageContentsSelectionList.getModel()).set(namesOfSsupportedFiles);
        if (filenames.size() > 0) {
            this.packageContentsSelectionList.setSelectedIndex(0);
        }
    }

    private void fillItemList() {
        String filename = "";
        if (this.status == 1) {
            filename = (String)this.packageContentsSelectionList.getSelectedValue();
        } else if (this.status == 2) {
            filename = String.valueOf(Paths.pathEndingWithSeparator(this.path)) + this.fileSelectionList.getSelectedValue();
        } else {
            return;
        }
        if (Plugins.existsDiskInfoForExtension(FileTools.getExtension(filename))) {
            this.setItemEnabled(true);
            DiskInfo diskInfo = Plugins.getDiskInfoForExtension(FileTools.getExtension(filename));
            try {
                diskInfo.load(filename);
                this.itemLabelTop.setText(diskInfo.getHeader());
                ((ListListModel)this.itemSelectionList.getModel()).set(Arrays.asList(diskInfo.getDirectory()));
                this.itemLabelBottom.setText(diskInfo.getFooter());
                if (diskInfo.getDirectory().length > 0) {
                    this.itemSelectionList.setSelectedIndex(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.setItemEnabled(false);
        }
    }

    private void setPackageEnabled(boolean enabled) {
        this.packageContentsSelectionList.setEnabled(enabled);
        this.packageContentsSelectionList.setBackground(enabled ? UIManager.getDefaults().getColor("List.background") : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.packageContentsSelectionList.setForeground(enabled ? UIManager.getDefaults().getColor("List.foreground") : UIManager.getDefaults().getColor("TextField.inactiveForeground"));
        if (!enabled) {
            this.packageContentsSelectionList.setModel(new ListListModel());
        }
    }

    private void setItemEnabled(boolean enabled) {
        this.itemLabelTop.setEnabled(enabled);
        this.itemSelectionList.setEnabled(enabled);
        this.itemSelectionList.setBackground(enabled ? UIManager.getDefaults().getColor("List.background") : UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        this.itemSelectionList.setForeground(enabled ? UIManager.getDefaults().getColor("List.foreground") : UIManager.getDefaults().getColor("TextField.inactiveForeground"));
        this.itemLabelBottom.setEnabled(enabled);
        if (!enabled) {
            this.itemLabelTop.setText("");
            this.itemSelectionList.setModel(new ListListModel());
            this.itemLabelBottom.setText("");
        }
    }

    private void setTestEnabled(boolean enabled) {
        this.testButton.setEnabled(enabled);
    }

    public Const.CloseAction getCloseAction() {
        return this.closeAction;
    }

    static class FileFilter {
        private final String name;
        private final String extensions;

        public FileFilter(String name, String extensions) {
            this.name = name;
            this.extensions = extensions;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FileSelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 8719778811629472539L;

        public FileSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof String) {
                this.setIcon(Const.ICON_GS_FILE);
                String filename = (String)value;
                String extension = FileTools.getExtension(filename);
                if (Emulators.getSupportedMusicExtensions().contains(extension)) {
                    this.setIcon(Const.ICON_GS_MUSIC);
                }
                if (Emulators.getSupportedGameExtensions().contains(extension)) {
                    this.setIcon(Const.ICON_GS_GAME);
                }
                if (Plugins.existsDiskInfoForExtension(extension)) {
                    this.setIcon(Const.ICON_GS_IMAGE);
                }
                if (Plugins.existsExtractorForExtension(extension)) {
                    this.setIcon(Const.ICON_GS_COMPRESSED);
                }
                if ((filename = Paths.pathEndingWithoutSeparator(filename)).contains(File.separator)) {
                    filename = filename.substring(filename.lastIndexOf(File.separator), filename.length());
                }
                filename = Paths.pathStartingWithoutSeparator(filename);
                this.setText(filename);
            }
            return this;
        }
    }

    static class PathSelection {
        private final int indentation;
        private final String path;

        public PathSelection(int indentation, String path) {
            this.indentation = indentation;
            this.path = Paths.pathEndingWithSeparator(path);
        }

        public int getIndentation() {
            return this.indentation;
        }

        public String getPath() {
            return this.path;
        }
    }

    static class PathSelectionRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 297347628128200626L;

        public PathSelectionRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof PathSelection) {
                if (isSelected || cellHasFocus) {
                    this.setIcon(Const.ICON_GS_FOLDER_OPEN);
                } else {
                    this.setIcon(Const.ICON_GS_FOLDER);
                }
                PathSelection selection = (PathSelection)value;
                String pathName = selection.getPath();
                int indentation = selection.getIndentation();
                pathName = pathName.substring(0, pathName.length() - 1);
                if (pathName.contains(File.separator)) {
                    pathName = pathName.substring(pathName.lastIndexOf(File.separator), pathName.length());
                }
                pathName = Paths.pathStartingWithoutSeparator(pathName);
                this.setText(pathName);
                this.setBorder(new EmptyBorder(new Insets(0, indentation * 10, 0, 0)));
            }
            return this;
        }
    }
}

